# Remover Marca d'Água – ITBX v4.1.0

Solução desktop para remover marcas d'água de imagens com rapidez e precisão, em lote e 100% offline. Ideal para equipes de mídia, e‑commerce, imobiliárias, agências e profissionais que lidam com grandes volumes de fotos e precisam ganhar produtividade sem abrir mão da qualidade e da segurança dos arquivos.

## Benefícios
- Produtividade: tratamento em lote com navegação por teclado e pincel ajustável.
- Qualidade: reconstrução inteligente do fundo (inpainting) preserva textura e nitidez.
- Segurança: backup automático e reversão com 1 tecla; operação local e offline.
- Simplicidade: interface direta; clique para remover, sem curva de aprendizado.

## Principais Recursos
- Remoção inteligente por inpainting (OpenCV), com resultados naturais.
- Pincel ajustável em tempo real (`+`/`-`) para precisão fina da área.
- Navegação em lote por teclado (`n` próximo, `p` anterior) e clique para aplicar.
- Backup automático de toda a pasta antes de iniciar e reversão rápida (`r`).
- Suporte a imagens grandes com rolagem e escala, sem travamentos ou flicker.
- Compatível com caminhos longos no Windows (suporte a `\\?\`).
- Formatos suportados: `.jpg`, `.jpeg`, `.png`.
- Interface responsiva (fila de processamento) e barra inferior com controles.
- Operação totalmente offline: nenhuma imagem sai do seu computador.

## Como Funciona (visão comercial)
- A ferramenta cria uma cópia de segurança da pasta selecionada.
- Você navega pelas imagens e “pinta” sobre a marca d'água com o pincel.
- O algoritmo reconstrói automaticamente o fundo na área pintada, integrando cor e textura.
- O resultado substitui a imagem original, mantendo a possibilidade de desfazer via backup.

## Fluxo de Uso
1. Abrir o app e escolher a pasta de imagens.
2. Aguardar a criação automática do backup da pasta.
3. Usar `+`/`-` para ajustar o tamanho do pincel.
4. Clicar/arrastar sobre a marca d'água para remover.
5. Navegar com `n` (próxima) e `p` (anterior); `r` reverte a imagem atual a partir do backup.
6. `Esc` encerra o aplicativo com segurança.

## Requisitos Técnicos
- Sistema: Windows 10 ou superior (suporte especial a caminhos longos). Também executável em macOS/Linux quando utilizado via Python.
- Dependências (modo Python): OpenCV, Pillow, NumPy, Tkinter (padrão do Python). 
- Hardware: CPU padrão; 4 GB RAM recomendados para lotes maiores.
- Entradas: imagens `.jpg`, `.jpeg`, `.png` em pastas locais.

## Entrega e Implantação
- Pode ser entregue como executável (EXE) para Windows ou como script Python.
- Execução simples: selecionar a pasta e começar a tratar as imagens.
- Não requer internet, servidores ou contas em nuvem.

## Limitações Conhecidas
- Marcas d'água muito extensas ou com padrões altamente complexos podem exigir múltiplos passes.
- O resultado depende do conteúdo de fundo disponível ao redor da área pintada.
- A saída sobrescreve o arquivo original; a reversão está disponível via backup automático.

## Casos de Uso
- Lojas virtuais e marketplaces (padronização de catálogo).
- Imobiliárias e construtoras (limpeza de material para anúncios).
- Agências de marketing e produtoras (alta produtividade em lote).
- Creators e social media (tratamento rápido de fotos para posts).

## Privacidade e Conformidade
- 100% offline: nenhum arquivo é enviado para a internet.
- Backup automático com data/hora garante rastreabilidade e reversão segura.

## Roadmap (opcional)
- Suporte a novos formatos de imagem.
- Exportação para pasta separada (modo não-destrutivo adicional).
- Pincel inteligente para marcas repetidas em posições padrão.

---
ITBX TECH – produtividade e qualidade na edição de imagens, sem complicação.
